﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="../Project.master"
    CodeBehind="ProjectKanbanList.aspx.cs" Inherits="GUI.CodeTables.ProjectKanbanList"
    EnableEventValidation="false" %>
<%@ Register Src="~/Controls/CodeTablesNavigation.ascx" TagName="CodeTablesNavigation" TagPrefix="uc" %>
<%@ Register Src="~/Controls/LanguageBox.ascx" TagName="LanguageBox" TagPrefix="uc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="FormPlaceHolder" runat="server">
    <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue kendo-form">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_KanbanProject %>" /> </span>
                        <span class="caption-helper"></span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-9">
                                <uc:LanguageBox ID="LanguageBox" runat="server" Visible="true" />
                            </div>  
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">Id</label>
                                    <asp:TextBox CssClass="form-control" runat="server" ID="txtId" Enabled="False" />
                                </div>
                            </div>
                             <div class="col-md-4">
                                <div class="form-group">
                                              <label class="control-label"><asp:Literal ID="Literal15" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Project %>" /></label>  
                     <asp:DropDownList CssClass="form-control" ID="ddlProject" runat="server">
                                  </asp:DropDownList>
                                 </div>
                            </div>
                             <div class="col-md-4">
                                                                <div class="form-group">
                                              <label class="control-label"><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Codes_KanbanColumns %>" /></label>  
                     <asp:DropDownList CssClass="form-control" ID="ddlColumns" runat="server">
                                  </asp:DropDownList>
                                 </div>
                            </div>
                                                         <div class="col-md-4">
                                                                <div class="form-group">
                                              <label class="control-label"><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Colors %>" /></label>  
                                       <asp:DropDownList CssClass="form-control" ID="ddlColors" runat="server">
                                  </asp:DropDownList>
                                 </div>
                            </div>
                        </div>
                         <div class="form-actions right">
                              <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                                    runat="server" />
                                <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue " Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <telerik:RadGrid ID="grdProjectKanbanSettings" runat="server" OnNeedDataSource="grdProjectKanbanSettings_NeedDataSource" OnItemDataBound="grdProjectKanbanSettings_ItemDataBound" OnItemCommand="grdProjectKanbanSettings_ItemCommand" Skin="Bootstrap">
					                <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" ShowFooter="False" AutoGenerateColumns="False"
						                AllowCustomSorting="false" DataKeyNames="Id">
						                <Columns>
							                <telerik:GridBoundColumn UniqueName="IdSettings" HeaderText="Id" DataField="Id" />
							                <telerik:GridBoundColumn UniqueName="ProjectColumn"  SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Project %>"
								                DataField="ProjectId" />
							                <telerik:GridBoundColumn UniqueName="KanbanColumn" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Codes_KanbanColumns %>"
								                DataField="ColumnId" />
                                            <telerik:GridBoundColumn UniqueName="ColumnColor" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Colors %>"
								                DataField="ColumnColor" />
							                <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Edit %>" />
							                <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>"/>
						                </Columns>
					                </MasterTableView>
				                </telerik:RadGrid>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:CodeTablesNavigation ID="CodeTablesNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="InfoPlaceHolder" runat="server"></asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="TitlePlaceHolder" runat="server"></asp:Content>